/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.block.woodtypes;

import azmalent.cuneiform.lib.registry.BlockEntry;
import azmalent.cuneiform.lib.util.DataUtil;
import azmalent.terraincognita.TerraIncognita;
import azmalent.terraincognita.client.renderer.ModChestISTER;
import azmalent.terraincognita.common.block.PottablePlantEntry;
import azmalent.terraincognita.common.block.chests.ModChestBlock;
import azmalent.terraincognita.common.block.chests.ModTrappedChestBlock;
import azmalent.terraincognita.common.block.signs.ModStandingSignBlock;
import azmalent.terraincognita.common.block.signs.ModWallSignBlock;
import azmalent.terraincognita.common.item.ModBoatItem;
import azmalent.terraincognita.common.item.block.ModSignItem;
import azmalent.terraincognita.common.registry.ModBlocks;
import azmalent.terraincognita.common.registry.ModItems;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.trees.Tree;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;

public class ModWoodType {
    public final String name;
    public final MaterialColor woodColor;
    public final MaterialColor barkColor;
    public final PottablePlantEntry SAPLING;
    public final BlockEntry LEAVES;
    public final BlockEntry LOG;
    public final BlockEntry STRIPPED_LOG;
    public final BlockEntry WOOD;
    public final BlockEntry STRIPPED_WOOD;
    public final BlockEntry PLANKS;
    public final BlockEntry STAIRS;
    public final BlockEntry SLAB;
    public final BlockEntry FENCE;
    public final BlockEntry FENCE_GATE;
    public final BlockEntry WALL_SIGN;
    public final BlockEntry SIGN;
    public final BlockEntry DOOR;
    public final BlockEntry TRAPDOOR;
    public final BlockEntry BUTTON;
    public final BlockEntry PRESSURE_PLATE;
    public final BlockEntry CHEST;
    public final BlockEntry TRAPPED_CHEST;
    public final RegistryObject<Item> BOAT;
    public final ResourceLocation SIGN_TEXTURE;
    public final ResourceLocation BOAT_TEXTURE;

    public ModWoodType(String id, Tree tree, MaterialColor woodColor, MaterialColor barkColor) {
        this.name = id;
        this.woodColor = woodColor;
        this.barkColor = barkColor;
        this.SAPLING = ModBlocks.createPlant(id + "_sapling", () -> new SaplingBlock(tree, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196674_t)));
        this.LEAVES = ModBlocks.HELPER.newBuilder(id + "_leaves", this::createLeaves).cutoutMippedRender().build();
        this.LOG = ModBlocks.HELPER.newBuilder(id + "_log", () -> this.createLogBlock(woodColor, barkColor)).withItemGroup(ItemGroup.field_78030_b).build();
        this.STRIPPED_LOG = ModBlocks.HELPER.newBuilder("stripped_" + id + "_log", () -> this.createLogBlock(woodColor, woodColor)).withItemGroup(ItemGroup.field_78030_b).build();
        this.WOOD = ModBlocks.HELPER.newBuilder(id + "_wood", () -> this.createWoodBlock(barkColor)).withItemGroup(ItemGroup.field_78030_b).build();
        this.STRIPPED_WOOD = ModBlocks.HELPER.newBuilder("stripped_" + id + "_wood", () -> this.createWoodBlock(barkColor)).withItemGroup(ItemGroup.field_78030_b).build();
        this.PLANKS = ModBlocks.HELPER.newBuilder(id + "_planks", () -> this.createPlanks(woodColor)).withItemGroup(ItemGroup.field_78030_b).build();
        this.STAIRS = ModBlocks.HELPER.newBuilder(id + "_stairs", () -> new StairsBlock(this.PLANKS.getBlock().func_176223_P(), AbstractBlock.Properties.func_200950_a((AbstractBlock)this.PLANKS.getBlock()))).withItemGroup(ItemGroup.field_78030_b).build();
        this.SLAB = ModBlocks.HELPER.newBuilder(id + "_slab", () -> new SlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)this.PLANKS.getBlock()))).withItemGroup(ItemGroup.field_78030_b).build();
        this.FENCE = ModBlocks.HELPER.newBuilder(id + "_fence", FenceBlock::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)).build();
        this.FENCE_GATE = ModBlocks.HELPER.newBuilder(id + "_fence_gate", FenceGateBlock::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)).build();
        this.BUTTON = ModBlocks.HELPER.newBuilder(id + "_button", WoodButtonBlock::new, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196689_eF)).withItemGroup(ItemGroup.field_78028_d).build();
        this.PRESSURE_PLATE = ModBlocks.HELPER.newBuilder(id + "_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a))).withItemGroup(ItemGroup.field_78028_d).build();
        this.DOOR = ModBlocks.HELPER.newBuilder(id + "_door", DoorBlock::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_()).withTallBlockItem(ItemGroup.field_78028_d).cutoutRender().build();
        this.TRAPDOOR = ModBlocks.HELPER.newBuilder(id + "_trapdoor", TrapDoorBlock::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_((state, reader, pos, entity) -> false)).withItemGroup(ItemGroup.field_78028_d).cutoutRender().build();
        this.SIGN = ModBlocks.HELPER.newBuilder(id + "_sign", () -> new ModStandingSignBlock(this)).withBlockItem(block -> new ModSignItem(this)).build();
        this.WALL_SIGN = ModBlocks.HELPER.newBuilder(id + "_wall_sign", () -> new ModWallSignBlock(this)).withoutItemForm().build();
        this.CHEST = ModBlocks.HELPER.newBuilder(id + "_chest", () -> new ModChestBlock(this)).withItemProperties(new Item.Properties().func_200916_a(ItemGroup.field_78031_c).setISTER(() -> ModChestISTER::forNormalChest)).build();
        this.TRAPPED_CHEST = ModBlocks.HELPER.newBuilder(id + "_trapped_chest", () -> new ModTrappedChestBlock(this)).withItemProperties(new Item.Properties().func_200916_a(ItemGroup.field_78028_d).setISTER(() -> ModChestISTER::forTrappedChest)).build();
        this.BOAT = ModItems.ITEMS.register(id + "_boat", () -> new ModBoatItem(this));
        this.SIGN_TEXTURE = TerraIncognita.prefix("entity/sign/" + this.name);
        this.BOAT_TEXTURE = TerraIncognita.prefix("textures/entity/boat/" + this.name + ".png");
    }

    public ResourceLocation getChestTexture(ChestType type, boolean trapped) {
        String location = "entity/chest/" + this.name + "_";
        if (trapped) {
            location = location + "trapped_";
        }
        location = location + type.func_176610_l();
        return TerraIncognita.prefix(location);
    }

    protected Block createLogBlock(MaterialColor topColor, MaterialColor barkColor) {
        return new RotatedPillarBlock(AbstractBlock.Properties.func_235836_a_((Material)Material.field_151575_d, state -> state.func_177229_b((Property)RotatedPillarBlock.field_176298_M) == Direction.Axis.Y ? topColor : barkColor).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a));
    }

    protected Block createWoodBlock(MaterialColor color) {
        return new RotatedPillarBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a));
    }

    protected Block createPlanks(MaterialColor color) {
        return new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
    }

    protected Block createLeaves() {
        return new LeavesBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c).func_226896_b_().func_235827_a_((state, reader, pos, entity) -> entity == EntityType.field_200781_U || entity == EntityType.field_200783_W).func_235842_b_((state, reader, pos) -> false).func_235847_c_((state, reader, pos) -> false));
    }

    public void initFlammability() {
        DataUtil.registerFlammable((Block)this.LEAVES.getBlock(), (int)30, (int)60);
        DataUtil.registerFlammable((Block)this.LOG.getBlock(), (int)5, (int)5);
        DataUtil.registerFlammable((Block)this.STRIPPED_LOG.getBlock(), (int)5, (int)5);
        DataUtil.registerFlammable((Block)this.WOOD.getBlock(), (int)5, (int)5);
        DataUtil.registerFlammable((Block)this.STRIPPED_WOOD.getBlock(), (int)5, (int)5);
        DataUtil.registerFlammable((Block)this.PLANKS.getBlock(), (int)5, (int)20);
        DataUtil.registerFlammable((Block)this.STAIRS.getBlock(), (int)5, (int)20);
        DataUtil.registerFlammable((Block)this.SLAB.getBlock(), (int)5, (int)20);
        DataUtil.registerFlammable((Block)this.FENCE.getBlock(), (int)5, (int)20);
        DataUtil.registerFlammable((Block)this.FENCE_GATE.getBlock(), (int)5, (int)20);
    }
}

